/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.traceroute.CheckPing;
import ibm.nways.jdm.traceroute.RemotePingCisco;
import ibm.nways.jdm.traceroute.RemotePingException;
import ibm.nways.jdm.traceroute.RemotePingIBM;
import java.io.Serializable;
import java.util.ResourceBundle;

public class RemotePing
implements Serializable {
    protected IPAddress ipAddress;
    protected String communityName;
    protected String voyagerAddress;
    protected String mibName = "";
    protected boolean pingSupported = false;
    private static ResourceBundle strings = ResourceBundle.getBundle((class$ibm$nways$jdm$traceroute$TraceRouteResources != null ? class$ibm$nways$jdm$traceroute$TraceRouteResources : (class$ibm$nways$jdm$traceroute$TraceRouteResources = RemotePing.class$("ibm.nways.jdm.traceroute.TraceRouteResources"))).getName());
    public static final int DEFAULT_ATTEMPTS = 3;
    public static final int DEFAULT_PACKET_SIZE = 100;
    public static final int DEFAULT_TIMEOUT_SECS = 3;
    private static final boolean debug = false;
    static /* synthetic */ Class class$ibm$nways$jdm$traceroute$TraceRouteResources;

    private RemotePing(IPAddress iPAddress, String string, String string2) {
        this(iPAddress, string, strings.getString("RemotePingNone"), string2);
    }

    protected RemotePing(IPAddress iPAddress, String string, String string2, String string3) {
        this.ipAddress = iPAddress;
        this.communityName = string;
        this.mibName = string2;
        this.voyagerAddress = string3;
    }

    public static RemotePing create(IPAddress iPAddress, String string, String string2) {
        RemotePing remotePing = new RemotePing(iPAddress, string, string2);
        RemotePingIBM remotePingIBM = new RemotePingIBM(iPAddress, string, string2);
        RemotePingCisco remotePingCisco = new RemotePingCisco(iPAddress, string, string2);
        CheckPing checkPing = new CheckPing(remotePingIBM);
        CheckPing checkPing2 = new CheckPing(remotePingCisco);
        checkPing.start();
        checkPing2.start();
        while (!checkPing.finished() || !checkPing2.finished()) {
            try {
                checkPing.join();
                checkPing2.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        RemotePing remotePing2 = checkPing.supportsPing() ? remotePingIBM : (checkPing2.supportsPing() ? remotePingCisco : remotePing);
        checkPing.stop();
        checkPing2.stop();
        checkPing = null;
        checkPing2 = null;
        return remotePing2;
    }

    public int remotePing(IPAddress iPAddress) throws RemotePingException {
        return this.remotePing(iPAddress, 3, 100, 3);
    }

    public int remotePing(IPAddress iPAddress, int n, int n2, int n3) throws RemotePingException {
        throw new RemotePingException(6, "Node does not support remote ping");
    }

    public boolean pingSupported() {
        return this.pingSupported;
    }

    public String getMibName() {
        return this.mibName;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

